/* 
 *  BinDataTab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DataI;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class BinDataTab extends BinDataTabBase {

    private final Button editString;
    private final Button deleteData;
    private final InteractionExecutor interactionExe;
    private final InteractionDataGUI gui;
    private static final String BLANKDATAMESSAGE = "no DATA to display, enter binary data as HEX pairs, ie: A1B2";
    private static final Logger LOG = Logger.getLogger(BinDataTab.class);

    public BinDataTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        super(BLANKDATAMESSAGE);
        this.interactionExe = interactionExe;
        this.gui = gui;

        HBox buttons = new HBox();

        editString = new Button("Edit");
        editString.setDisable(true);
        editString.getStyleClass().add("intrinsicButton");
        editString.setOnAction((ActionEvent t) -> {
            String text = dataEditor.getText();
            LOG.info(editString.getText() + ":" + text);
            editDataDialog(text);
        });

        deleteData = new Button("Delete");
        deleteData.setDisable(true);
        deleteData.getStyleClass().add("intrinsicButton");
        deleteData.setOnAction((ActionEvent t) -> {
            String id = gui.getCurrentItemSelection().getId();
            LOG.info("DeleteButton() ID:"+ id);
            interactionExe.deleteDATA(id);
        });

        buttons.getChildren().addAll(editString, deleteData);
        pane.setBottom(buttons);
    }

    private void editDataDialog(String newStrData) {
        Dialog<String> dialog = new Dialog<>();
        dialog.setTitle("Save Data");

        ButtonType saveButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll(saveButtonType, ButtonType.CANCEL);

        GridPane grid = new GridPane();
        grid.getStyleClass().add("dialog");

        TextField data = new TextField();
        data.setText(newStrData);

        grid.add(new Label("DATA:"), 0, 0);
        grid.add(data, 1, 0);

        dialog.getDialogPane().setContent(grid);

        Platform.runLater(() -> data.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == saveButtonType) {
                return data.getText();
            }
            return null;
        });

        Optional<String> result = dialog.showAndWait();

        result.ifPresent(resultData -> {
            String methodName = "editDataDialog() ";
            String newBinValue = resultData.toUpperCase();
            if (isStringHex(newBinValue)) {
                LOG.trace(methodName + "Updating DATA to:" + newBinValue);
                interactionExe.setDATA(gui.getCurrentItemSelection().getId(), hexStringToByteArray(newBinValue));
            } else {
                LOG.error(methodName + "data must represent HEX values and be a multiple of 2");
            }
        });
    }

    @Override
    void update(InteractionDataI data) {
        boolean disable = !data.canGetData();
        this.dataEditor.setDisable(disable);
        this.tab.setDisable(disable);
        this.editString.setDisable(!data.canGetData());

        DataI dataInstance = data.getData();
        if (dataInstance != null) {
            deleteData.setDisable(false);
            switch (dataInstance.getFormat()) {
            case BIN:
                this.tab.setDisable(false);
                dataEditor.setText(bytesToHex(dataInstance.getBinaryData()));
                break;
            case KVP:
                this.tab.setDisable(true);
                break;
            case STR:
                this.tab.setDisable(true);
                break;
            case UNKNOWN:
                dataEditor.setText(getBlankdata());
                break;
            }
        } else {
            deleteData.setDisable(true);
            dataEditor.setText(getBlankdata());
        }
    }
}
